<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Classroom extends Model 
{

    protected $table = 'Classrooms';
    public $timestamps = true;
    protected $fillable = array('name', 'programType_id', 'schedule', 'starting_date', 'notes', 'duration');

    public function programTypeRelation()
    {
        return $this->belongsTo('App\Models\Program_Types', 'programType_id');
    }

    public function classroomTeacherRelation()
    {
        return $this->belongsToMany('App\Models\Teacher', 'Classroom_Teacher');
    }

    public function classroomStudentRelation()
    {
        return $this->belongsToMany('App\Models\Student', 'Classroom_Student');
    }

    public function classroomRegRelation()
    {
        return $this->belongsToMany('App\Models\Registration', 'classroom_registration');
    }

}